﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Project.master" AutoEventWireup="true"
    CodeBehind="ProjectExpense.aspx.cs" Inherits="GUI.Pages.ProjectExpense" %>

<%@ Register Src="~/Controls/ExpenseNavigation.ascx" TagName="ExpenseNavigation" TagPrefix="uc" %>
<asp:Content ID="Content3" ContentPlaceHolderID="LeftNavigationPlaceHolder" runat="server">
    <uc:ExpenseNavigation ID="ExpenseNavigation" runat="server" />
</asp:Content>
<asp:Content ID="Content4" ContentPlaceHolderID="FormPlaceHolder" runat="server">
<telerik:RadAjaxPanel ID="RadAjaxPanel1" runat="server" EnableAJAX="true" LoadingPanelID="RadAjaxLoadingPanel1">
    <div class="main-form-box">
        <h2><asp:Literal ID="Literal4" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_Expense %>" /></h2>
        <div class="form-wrapper">
            <div class="row">
                <div class="four columns">
                    <div class="formField ">
                        <asp:HiddenField runat="server" ID="txtExpenseId" />
                        <label>
                            <asp:Literal ID="Literal1" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_Name %>" /></label>
                        <asp:TextBox runat="server" ID="txtName" />
                        <asp:RequiredFieldValidator ID="txtNameRequired" runat="server" Display="Dynamic"
                            CssClass="vError" SetFocusOnError="true" ControlToValidate="txtName" ErrorMessage="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>"
                            ToolTip="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>">* <asp:Literal ID="Literal5" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>" /></asp:RequiredFieldValidator>
                    </div>
                </div>
                <div class="two columns">
                    <div class="formField ">
                        <label><asp:Literal ID="Literal2" runat="server" Text="<%$ Resources:ProjectManagementUI, Expense_Planned %>" /></label>
                        <asp:CheckBox runat="server" ID="chkIsPlanned" />
                    </div>
                </div>
                <div class="two columns">
                    <div class="formField ">
                        <label><asp:Literal ID="Literal3" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_Date %>" /></label>
                        <telerik:RadDatePicker runat="server" ID="dtpExpenseDate" />
                    </div>
                </div>
                <div class="two columns">
                    <div class="formField">
                        <label><asp:Literal ID="Literal6" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_Type %>" /></label>
                        <asp:DropDownList runat="server" ID="ddlExpenseType" />
                    </div>
                </div>
                <div class="two columns">
                    <div class="formField">
                        <label><asp:Literal ID="Literal7" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_Amount %>" /></label>
                           <telerik:RadNumericTextBox Type="Number" Font-Bold="True" runat="server" ID="txtPrice"
                            CssClass="currency" />
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="twelve columns">
                    <div class="formField ">
                        <label>
                            <asp:Literal ID="Literal8" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_Description %>" /></label>
                        <asp:TextBox TextMode="MultiLine" Rows="4" runat="server" ID="txtDescription" />
                    </div>
                </div>
                <div class="clear">
                </div>
            </div>

			<br />
				<div class="row">
				
					<div class="twelve columns">
					
						<div class="qsf-demo-canvas qsf-demo-canvas-vertical">
						<telerik:RadPanelBar runat="server" ID="RadPanelBar1" Width="100%" Skin="Office2010Silver" Visible="true">
							<Items>
								<telerik:RadPanelItem Expanded="False" Text="<%$ Resources:ProjectManagementUI, Common_NotifyUsers %>">
									<ContentTemplate>
										        <div class="raw">
                                                    <div class="col-md-12">
                                                        <div class="form-group">
                                                            <label class="control-label"></label>
                                                            <div class="mt-checkbox-list">
                                                                <label class="mt-checkbox bold"> <asp:Literal ID="Literal25" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_SelectAll %>" />
                                                                    <input type="checkbox" id="chkCheckAll"  onchange="javascript:SelektujSve(this.checked);"/>
                                                                    <span></span>
                                                                </label>
                                                            </div>

                                                            <asp:DataList ID="chkUsers" runat="server" RepeatColumns="10">
                                                                <ItemTemplate>
                                                                     <div class="mt-checkbox-list">
                                                                        <label class="mt-checkbox bold select-users" style="margin-left: 10px;">
                                                                            <asp:CheckBox ID="checkBoxUser" runat="server" Text='<%#Eval("Name") %>'/>
                                                                            <asp:HiddenField ID="hdnuserid" runat="server" Value='<%#Eval("Id") %>' />
                                                                            <span></span>

                                                                        </label>
                                                                    </div>
                                                               
                                                                </ItemTemplate>
                                                            </asp:DataList>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-12">
                                                        <div class="form-group">
                                                            <label class="control-label"><asp:Literal ID="Literal26" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_Message %>" /></label>
                                                            <asp:TextBox CssClass="form-control" Rows="3" Width="100%" TextMode="MultiLine" runat="server" ID="txtComment" />
                                                        </div>
                                                    </div>
										        </div>
									        </ContentTemplate>
								</telerik:RadPanelItem>
							</Items>
						</telerik:RadPanelBar>
					</div>
					
					
					</div>

				</div>

            <div class="row">
                <div class="twelve columns">
                    <div class="buttonBar">
                        <asp:Button ID="btnSave" OnClick="BtnSaveClick" CssClass="button orange" Text="<%$ Resources:ProjectManagementUI, Common_Save %>"
                            runat="server" />
                        <asp:Button ID="btnNew" OnClick="BtnNewClick" CssClass="button" Text="<%$ Resources:ProjectManagementUI, Common_New %>" runat="server" />
                    </div>
                </div>
                <div class="clear">
                </div>
            </div>
        </div>
    </div>
    </telerik:RadAjaxPanel>

   <telerik:RadAjaxLoadingPanel runat="server" ID="RadAjaxLoadingPanel1"  >
        <div class="updatePanelProgress"><asp:Literal ID="ltrPLeaseWait" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_PleaseWait %>" />...</div>
    </telerik:RadAjaxLoadingPanel> 
    
    <script type="text/javascript">
        function OnClientEntryAddingHandler(sender, eventArgs) {

            if (sender.get_entries().get_count() == 1) {
                eventArgs.set_cancel(true);
                alert('<%= GetLexicalItem("Error_YouCanChooseOneActivity")%>');
            }
        }

</script>

<script type="text/javascript">

    $(document).ready(function () {

        $("#chkCheckAll").bind('click', function () {
            if ($(this).is(':checked')) {
                $('.checkBoxList input').each(function () { $(this).attr('checked', true) });
            }
            else {
                $('.checkBoxList input').each(function () { $(this).attr('checked', false) });
            }
        });

    });

	</script>
</asp:Content>
